/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4,
maxerr: 50, node: true */
/*global dw, DWfile, DWUri, dwscripts*/

(function () {
	"use strict";

	// In this file, directory URLs do not have '/' at the end.
	var updatesDirURL = dw.getUserConfigurationPath() + "Updates";
	var processCompleteMarkerFileURL = updatesDirURL + "/Marker/processComplete";
	var updatesPropertiesFileURL = updatesDirURL + "/Iam/Strings/updatesInfo.properties";
	var patchPropertiesFileURL = updatesDirURL + "/Iam/Strings/patchInfo.properties";
	var notificationPropertiesFileURL = updatesDirURL + "/Iam/Strings/notificationInfo.properties";
	var nodeArgs = [];
	var nodeURL;
	var prefsSection = "Updates";
	var prefsReminderTimePatch = "Reminder Time For Patch";
	var prefsReminderTimeUpdates = "Reminder Time For Updates";
	var remindNever = "Never";
    var mode = "Mode";
	var lastShownNotificationId = "Last Shown Notification Id";
	var hintUrlToShow = "";
    
    //Headlights
    var UT_UPDATES_SUBCATEGORY = "InAppUpdates";
    var UT_UPDATES_DISPLAYED = "Update_Displayed";
    var UT_UPDATES_DWPATCH_DISPLAYED = "DWPatch_Displayed";
    var UT_UPDATES_NOTIFICATION_DISPLAYED = "DWNotify_Displayed";

    var ModeEnum = {
        MANUAL : 0,
        AUTO : 1,
        TURNOFF : 2
    };
        
	function _shouldCheckUpdates() {
		// If install.xml exists, it means previously downloaded updates
		// are not yet installed, so do not check for new updates.
		var installXmlURL = updatesDirURL + "/Install/install.xml";
		if (DWfile.exists(installXmlURL, false)) {
			return false;
		}
		return true;
	}

	function _toPath(url) {
		var uri = new DWUri(url);
		var path = (dwscripts.IS_WIN ? uri.toLocalPath() : uri.toLocalPathUnix());
		return path;
	}

	function _toUrl(path) {
		return dwscripts.filePathToLocalURL(path);
	}

	// Get id of the latest successfully installed update.
	function _getCurrentUpdateId() {
		var uninstallXmlURL = updatesDirURL + "/Uninstall/uninstall.xml";
		var uninstallDOM;
		var updateNodes;
		var latestUpdate;
		var id;

		if (!DWfile.exists(uninstallXmlURL, false)) {
			return "0";
		}

		uninstallDOM = dw.getDocumentDOM(uninstallXmlURL);
		if (!uninstallDOM) {
			return "0";
		}

		updateNodes = uninstallDOM.getElementsByTagName("update");

		if (updateNodes && updateNodes.length > 0) {
			id = updateNodes[updateNodes.length - 1].getAttribute("id");
			if (id) {
				return id;
			}
		}
		return "0";
	}

	// Get id of the latest shown notification Id
	function _getCurrentNotificationId() {
		var notificationIdStr = dw.getPreferenceString(prefsSection, lastShownNotificationId, "0");
		return notificationIdStr;
	}
	
	function _populateNodeArgs() {

		// first argument is script path
		var quote = dwscripts.IS_WIN ? "\"" : "";
		var scriptPath = _toPath(updatesDirURL + "/Core/Node/download.js");
		nodeArgs.push(quote + scriptPath + quote);

		// arguments to the script
		nodeArgs.push("locale=" + dw.getAppLanguage());
		nodeArgs.push("os=" + (dwscripts.IS_WIN ? "win" : "mac"));
		nodeArgs.push("currentUpdateId=" + _getCurrentUpdateId());
		nodeArgs.push("currentNotificationId=" + _getCurrentNotificationId());
		nodeArgs.push(quote + "updatesDir=" + _toPath(updatesDirURL) + quote);
		nodeArgs.push("download=info"); // download only info

		// dw.appVersion => major.minor.dotminor.build
		var appVersion = dw.appVersion.split(" ")[0];
		if (appVersion.split(".").length === 4) {
			// appVersion => major.minor.dotminor
			appVersion = appVersion.split(".").slice(0, -1).join(".");
		}

		nodeArgs.push("appVersion=" + appVersion);
		nodeArgs.push("coreVersion=v1"); // Revision of core logic of "Updates"
	}

	function _cleanupPreLaunch() {
		DWfile.remove(processCompleteMarkerFileURL);
		DWfile.remove(updatesPropertiesFileURL);
		DWfile.remove(patchPropertiesFileURL);
        DWfile.remove(notificationPropertiesFileURL);
	}

	function _watchMarkerFile() {

		var patchIamURL = updatesDirURL + "/Iam/patch.html";
		var updatesIamURL = updatesDirURL + "/Iam/updates.html?showClose=false";
        var notificationIamURL = updatesDirURL + "/Iam/notification.html";
        
		function _findHintsCanBeShown(canShowHintArray) {
            
            if (canShowHintArray.canNotificationBeShown === null ||
                    canShowHintArray.canPatchBeShown === null ||
                    canShowHintArray.canUpdatesBeShown === null) {
                return;
            }
            var patchAvailable = DWfile.exists(patchPropertiesFileURL, false);
			var updatesAvailable = DWfile.exists(updatesPropertiesFileURL, false);
            
            var now = new Date();
            var nowSeconds = Math.floor(now.getTime() / 1000);

            if (patchAvailable) {

                // Preference values: Empty string, time in seconds and "Never".
                // If its "Never", don't show hint. If its empty string or time is earlier than the current time, show hint.
                var patchReminderTimeStr = dw.getPreferenceString(prefsSection, prefsReminderTimePatch, "");
                if (patchReminderTimeStr !== remindNever) {
                    var patchReminderSeconds = parseInt(patchReminderTimeStr, 10) || 0;
                    if (nowSeconds > patchReminderSeconds) {
                        canShowHintArray.canPatchBeShown = true;
                    }
                }
            }

            if (updatesAvailable) {

                // Preference values: Empty string, and time in seconds.
                // If its empty string or time is earlier than the current time, show hint.
                var updatesReminderTimeStr = dw.getPreferenceString(prefsSection, prefsReminderTimeUpdates, "");
                var updatesReminderSeconds = parseInt(updatesReminderTimeStr, 10) || 0;
                if (nowSeconds > updatesReminderSeconds) {
                    canShowHintArray.canUpdatesBeShown = true;
                }
            }
            
            canShowHintArray.canNotificationBeShown = DWfile.exists(notificationPropertiesFileURL, false);
		}

        function _doWatchForAllFeatureFloatersClosedAndShow() {
            if (hintUrlToShow) {
                if (!dw.isAnyFeatureFloaterShown()) {
                    dw.showHint(hintUrlToShow);
                } else {
                    setTimeout(_doWatchForAllFeatureFloatersClosedAndShow, 2000);
                }
            }
	    }
        
		function _doWatch() {
			hintUrlToShow = "";
			// Once updates are checked, marker file would be available
			if (DWfile.exists(processCompleteMarkerFileURL, false)) {

				// 1. Remove marker file
				DWfile.remove(processCompleteMarkerFileURL);
                
				// 2. Show or Download hint
                var canShowHintArray = {
                    canNotificationBeShown: false,
                    canPatchBeShown: false,
                    canUpdatesBeShown: false
                };
                _findHintsCanBeShown(canShowHintArray);
                var curMode = dw.getPreferenceInt(prefsSection, mode, 0);
                var eventName = "";
                if (curMode === ModeEnum.AUTO) {
                    if (canShowHintArray.canNotificationBeShown) {
                        hintUrlToShow = notificationIamURL;
                        _doWatchForAllFeatureFloatersClosedAndShow();
                        eventName = UT_UPDATES_NOTIFICATION_DISPLAYED;
                    } else if (canShowHintArray.canUpdatesBeShown) {
                        // Execute download script
                        var filePath = updatesDirURL + "/Core/Download.js";
                        if (DWfile.exists(filePath)) {
                            var text = DWfile.read(filePath);
                            eval(text);
                        }
                    } 
                } else if (curMode === ModeEnum.TURNOFF) {
                    if (canShowHintArray.canNotificationBeShown) {
                        hintUrlToShow = notificationIamURL;
                        _doWatchForAllFeatureFloatersClosedAndShow();
                        eventName = UT_UPDATES_NOTIFICATION_DISPLAYED;
                    }
                } else if (curMode === ModeEnum.MANUAL) {
                    var hintUrl = null;
					if (canShowHintArray.canPatchBeShown) {
                        hintUrl = patchIamURL;
                        eventName = UT_UPDATES_DWPATCH_DISPLAYED;
                    } else if (canShowHintArray.canNotificationBeShown) {
                        hintUrl = notificationIamURL;
                        eventName = UT_UPDATES_NOTIFICATION_DISPLAYED;
                    } else if (canShowHintArray.canUpdatesBeShown) {
                        hintUrl = updatesIamURL;
                        eventName = UT_UPDATES_DISPLAYED;
                    } 
                    if (hintUrl) {
						hintUrlToShow = hintUrl;
                        _doWatchForAllFeatureFloatersClosedAndShow();
                    }
                }
                if (eventName !== "") {
                    dw.logEvent(UT_UPDATES_SUBCATEGORY, eventName);
                }
			} else {
                setTimeout(_doWatch, 1000);
            }
		}

        _doWatch();
	}

	// 1. Check if new updates should be checked
	if (!_shouldCheckUpdates()) {
		return;
	}

	// 2. Get local URL of node
    var rootDirURL = _toUrl(dw.getRootDirectory());
	if (dwscripts.IS_MAC) {
        nodeURL = rootDirURL + dw.appName + ".app/Contents/MacOS/node";
        if (!DWfile.exists(nodeURL, false)) {
            nodeURL = rootDirURL + "Dreamweaver.app/Contents/MacOS/node";
            if (!DWfile.exists(nodeURL, false)) {
                return;
            }
        }
	} else {
        nodeURL = rootDirURL + "node/node.exe";
        if (!DWfile.exists(nodeURL, false)) {
            return;
        }
    }

	// 3. Populate node args
	_populateNodeArgs();

	// 4. Cleanup files before launching node
	_cleanupPreLaunch();

	// 5. Watch marker file to get status of node process
	_watchMarkerFile();

	// 6. Launch node
	dw.createProcess(nodeURL, nodeArgs);
}());
